<?php
// asaas_config.php
session_start();
require_once '../config.php';

// Verificar autenticação
if (!isset($_SESSION['admpag_user'])) {
    header('Location: login.php');
    exit;
}

// Buscar configurações existentes
$config = $pdo->query("SELECT * FROM asaas_settings LIMIT 1")->fetch();

// Processar formulário
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $data = [
            'api_key' => trim($_POST['api_key']),
            'mode' => in_array($_POST['mode'], ['sandbox', 'production']) ? $_POST['mode'] : 'sandbox',
            'webhook_token' => $config['webhook_token'] ?? bin2hex(random_bytes(16))
        ];

        // Validação básica
        if (empty($data['api_key'])) {
            throw new Exception("API Key é obrigatória!");
        }

        if ($config) {
            // Atualizar
            $stmt = $pdo->prepare("UPDATE asaas_settings SET 
                api_key = :api_key,
                mode = :mode,
                webhook_token = :webhook_token,
                updated_at = NOW()
                WHERE id = :id");
                
            $data['id'] = $config['id'];
        } else {
            // Inserir
            $stmt = $pdo->prepare("INSERT INTO asaas_settings 
                (api_key, mode, webhook_token, created_at, updated_at)
                VALUES (:api_key, :mode, :webhook_token, NOW(), NOW())");
        }

        $stmt->execute($data);
        $success = "Configurações salvas com sucesso!";
        
        // Recarregar configurações
        $config = $pdo->query("SELECT * FROM asaas_settings LIMIT 1")->fetch();

    } catch (Exception $e) {
        $error = "Erro: " . $e->getMessage();
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Configurações Asaas</title>
    <!-- Links para os estilos do Bootstrap e Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <!-- Link para o favicon -->
    <link rel="icon" href="https://www.pokemongobrasil.com/wp-content/uploads/2015/09/cropped-favicon.png" type="image/x-icon">
    <style>
        .webhook-info { background: #f8f9fa; padding: 20px; border-radius: 8px; }
        pre { background: #1e1e1e; color: #d4d4d4; padding: 15px; border-radius: 5px; }
        .sidebar {
            height: 100vh;
            position: fixed;
            width: 280px;
            background-color: #f8f9fa;
            padding: 20px;
        }
        .main-content {
            margin-left: 280px;
            padding: 20px;
        }
        .table-actions {
            width: 150px;
        }
    </style>
</head>
<body>
<!-- Menu Lateral -->
    <?php
        include_once("menu-lateral.php");
    ?>
    <!-- Fim do Menu Lateral -->
    <div class="main-content">
        <h2 class="mb-4">Configurações da Asaas</h2>

        <!-- Mensagens -->
        <?php if(isset($success)): ?>
            <div class="alert alert-success"><?= $success ?></div>
        <?php endif; ?>
        
        <?php if(isset($error)): ?>
            <div class="alert alert-danger"><?= $error ?></div>
        <?php endif; ?>

        <!-- Formulário -->
        <div class="card shadow">
            <div class="card-body">
                <form method="post">
                    <div class="mb-3">
                        <label class="form-label">API Key*</label>
                        <input type="text" name="api_key" class="form-control" 
                            value="<?= htmlspecialchars($config['api_key'] ?? '') ?>" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Modo*</label>
                        <select name="mode" class="form-select" required>
                            <option value="sandbox" <?= ($config['mode'] ?? 'sandbox') === 'sandbox' ? 'selected' : '' ?>>Sandbox (Testes)</option>
                            <option value="production" <?= ($config['mode'] ?? '') === 'production' ? 'selected' : '' ?>>Production (Produção)</option>
                        </select>
                    </div>

                    <?php if($config): ?>
                    <div class="webhook-info mb-4">
                        <h5>Configuração do Webhook</h5>
                        <div class="mb-2">
                            <strong>URL do Webhook:</strong>
                            <pre><?= htmlspecialchars(BASE_URL . '/webhook.php') ?></pre>
                        </div>
                        <div class="mb-2">
                            <strong>Token de Segurança:</strong>
                            <pre><?= htmlspecialchars($config['webhook_token']) ?></pre>
                        </div>
                        <small class="text-muted">Copie esses dados na configuração do webhook no painel da Asaas</small>
                    </div>
                    <?php else: ?>
                        <div class="alert alert-info">
                            O token do webhook será gerado automaticamente após o primeiro salvamento
                        </div>
                    <?php endif; ?>

                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-save"></i> Salvar Configurações
                    </button>
                </form>
            </div>
        </div>

        <!-- Instruções -->
        <div class="mt-4">
            <h4>Instruções de Configuração</h4>
            <ol>
                <li>Acesse o painel da Asaas</li>
                <li>Navegue até as configurações de webhook</li>
                <li>Configure a URL acima com o token fornecido</li>
                <li>Selecione os eventos de pagamento (PIX)</li>
            </ol>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>