<?php
session_start();

// Verificar se a sessão foi iniciada corretamente
if (!isset($_SESSION['admpag_user'])) {
    header("Location: login");
    exit();
}

// Conectar ao banco de dados (ajuste conforme necessário)
require_once '../config.php';

// Inicializar variáveis
$totalUsuarios = 0;
$totalPagamentos = 0;
$totalAssinaturasAtivas = 0;
$totalContasVencer = 0;

try {
    // Buscar o total de usuários
    $stmt = $pdo->query("SELECT COUNT(*) AS total FROM users");
    $totalUsuarios = $stmt->fetch(PDO::FETCH_ASSOC)['total'];

    // Buscar o total de pagamentos recebidos
    $stmt = $pdo->query("SELECT SUM(amount) AS total FROM pix WHERE status = 'pago'");
    $totalPagamentos = $stmt->fetch(PDO::FETCH_ASSOC)['total'] ?? 0;

    // Buscar o total de assinaturas ativas
    $stmt = $pdo->query("SELECT COUNT(*) AS total FROM pix WHERE status = 'ativa'");
    $totalAssinaturasAtivas = $stmt->fetch(PDO::FETCH_ASSOC)['total'];

    $stmt = $pdo->query("SELECT COUNT(*) AS total 
FROM users 
WHERE expired_in IS NOT NULL 
AND expired_in > NOW() 
AND expired_in <= DATE_ADD(NOW(), INTERVAL 90 DAY);
");
    $totalContasVencer = $stmt->fetch(PDO::FETCH_ASSOC)['total'];
    

    
    

} catch (PDOException $e) {
    error_log("Erro ao buscar estatísticas: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Painel Admin - MeuSite</title>
    
    <!-- Favicon -->
    <link rel="icon" href="https://www.pokemongobrasil.com/wp-content/uploads/2015/09/cropped-favicon.png" type="image/x-icon">

    <!-- Bootstrap e Ícones -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

    <style>
        .sidebar {
            height: 100vh;
            position: fixed;
            width: 280px;
            background-color: #f8f9fa;
            padding: 20px;
        }
        .main-content {
            margin-left: 280px;
            padding: 20px;
        }
        @media (max-width: 768px) {
            .sidebar {
                position: relative;
                height: auto;
                width: 100%;
            }
            .main-content {
                margin-left: 0;
            }
        }
        .info-box {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 20px;
            border-radius: 10px;
            color: white;
        }
        .bg-users { background-color: #007bff; }
        .bg-payments { background-color: #28a745; }
        .bg-subscriptions { background-color: #ffc107; }
        .bg-expiring { background-color: #dc3545; }
        .info-box i { font-size: 2rem; }
    </style>
</head>

<body>
    
    <!-- Menu Lateral -->
    <?php include_once("menu-lateral.php"); ?>
    <!-- Fim do Menu Lateral -->

    <!-- Conteúdo Principal -->
    <div class="main-content">
        
        <!-- Header -->
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2>Dashboard</h2>
        </div>

        <!-- Boxes de Informações -->
        <div class="row">
            <div class="col-md-3">
                <div class="info-box bg-users">
                    <div>
                        <h4><?= $totalUsuarios ?></h4>
                        <p>Usuários cadastrados</p>
                    </div>
                    <i class="bi bi-people"></i>
                </div>
            </div>
            <div class="col-md-3">
                <div class="info-box bg-payments">
                    <div>
                        <h4>R$ <?= number_format($totalPagamentos, 2, ',', '.') ?></h4>
                        <p>Pagamentos recebidos</p>
                    </div>
                    <i class="bi bi-cash-stack"></i>
                </div>
            </div>
            <div class="col-md-3">
                <div class="info-box bg-subscriptions">
                    <div>
                        <h4><?= $totalAssinaturasAtivas ?></h4>
                        <p>Assinaturas ativas</p>
                    </div>
                    <i class="bi bi-card-checklist"></i>
                </div>
            </div>
            <div class="col-md-3">
                <div class="info-box bg-expiring">
                    <div>
                        <h4><?= $totalContasVencer ?></h4>
                        <p>Contas a vencer</p>
                    </div>
                    <i class="bi bi-exclamation-triangle"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal de Confirmação -->
    <div class="modal fade" id="deleteModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Confirmar Exclusão</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    Tem certeza que deseja excluir este plano?
                </div>
                <div class="modal-footer">
                    <form method="post" id="deleteForm">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-danger">Excluir</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function confirmDelete(id) {
            document.getElementById('deleteForm').action = `/admin/plans/delete/${id}`;
            new bootstrap.Modal(document.getElementById('deleteModal')).show();
        }
    </script>
</body>
</html>
