<?php
session_start();
require_once '../config.php';

// Verifica se o formulário foi enviado via POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Coleta os dados do formulário
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';

    // Preparação da consulta para verificar o usuário
    $stmt = $pdo->prepare("SELECT * FROM admpag WHERE username = ? AND status = 1");
    $stmt->execute([$username]);
    $admin = $stmt->fetch();

    // Verifica se as credenciais são válidas
    if ($admin && password_verify($password, $admin['password'])) {
        // Armazena os dados do usuário na sessão
        $_SESSION['admpag_user'] = [
            'id' => $admin['id'],
            'username' => $admin['username'],
            'access_level' => $admin['access_level']
        ];

        // Atualiza o último login do administrador
        $pdo->prepare("UPDATE admpag SET last_login = NOW() WHERE id = ?")
            ->execute([$admin['id']]);
            
        // Redireciona para o painel (dashboard)
        header('Location: dashboard');
        exit;
    } else {
        $error = "Credenciais inválidas!";
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login Administrativo</title>
 <!-- Link para o favicon -->
    <link rel="icon" href="https://www.pokemongobrasil.com/wp-content/uploads/2015/09/cropped-favicon.png" type="image/x-icon">
    <!-- Link do Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        body {
            height: 100vh;
            display: grid;
            place-items: center;
            background: #f8f9fa;
        }
        .login-box {
            width: 100%;
            max-width: 400px;
            padding: 20px;
        }
        /* Tornar o layout responsivo em dispositivos menores */
        @media (max-width: 575px) {
            .login-box {
                width: 90%;
            }
        }
    </style>
</head>
<body>
    <div class="login-box">
        <div class="card shadow">
            <div class="card-body">
                <h4 class="card-title mb-4 text-center">Painel Administrativo</h4>

                <!-- Exibe a mensagem de erro, se houver -->
                <?php if (isset($error)): ?>
                    <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
                <?php endif; ?>

                <!-- Formulário de login -->
                <form method="post">
                    <div class="mb-3">
                        <label class="form-label" for="username">Usuário</label>
                        <input type="text" name="username" id="username" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label" for="password">Senha</label>
                        <input type="password" name="password" id="password" class="form-control" required>
                    </div>
                    <button type="submit" class="btn btn-primary w-100">Entrar</button>
                </form>
            </div>
        </div>
    </div>

    <!-- Scripts Bootstrap -->
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.min.js"></script>
</body>
</html>
