<?php
// user_details.php
require_once '../config.php';

if (!isset($_GET['id'])) exit;

$userId = (int)$_GET['id'];
$stmt = $pdo->prepare("
    SELECT 
    u.*, 
    COALESCE(p.name, 'Nenhum') AS pack_name, 
    pg.payment_id, 
    pg.created_at AS last_payment, 
    pg.status AS payment_status 
FROM users u
LEFT JOIN pix pg ON u.id = pg.user_id 
LEFT JOIN planospix p ON u.pack_id = p.id 
WHERE u.id = ? 
ORDER BY pg.created_at DESC 
LIMIT 1

");
$stmt->execute([$userId]);
$user = $stmt->fetch();

/*echo "<pre>";
print_r($user);
echo "</pre>";

die();*/

if (!$user) exit;
?>
<html>
    <head>
    <meta charset="UTF-8">
    <title>Gerenciar Usuários</title>
    
<!-- Link para o favicon -->
    <link rel="icon" href="https://www.pokemongobrasil.com/wp-content/uploads/2015/09/cropped-favicon.png" type="image/x-icon">

    <!-- Links para os estilos do Bootstrap e Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <link href="https://cdn.datatables.net/1.13.1/css/jquery.dataTables.min.css" rel="stylesheet">

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

    <style>
        .sidebar {
            height: 100vh;
            position: fixed;
            width: 280px;
            background-color: #f8f9fa;
            padding: 20px;
        }
        .main-content {
            margin-left: 280px;
            padding: 20px;
        }
    </style>
</head>
<body>
    <?php include_once("menu-lateral.php"); ?>
    
    <div class="main-content">
        <div class="card">
            <div class="container-fluid">
            <h2 class="mb-4">Gerenciamento de Usuários</h2>
                <div class="row">
            <div class="col-md-6">
                <h5>Informações Básicas</h5>
                <ul class="list-group">
                    <li class="list-group-item">
                        <strong>ID:</strong> <?= $user['id'] ?>
                    </li>
                    <li class="list-group-item">
                        <strong>Nome:</strong> <?= htmlspecialchars($user['name']) ?>
                    </li>
                    <li class="list-group-item">
                        <strong>Email:</strong> <?= htmlspecialchars($user['email']) ?>
                    </li>
                    <li class="list-group-item">
                        <strong>Cadastro:</strong> <?= date('d/m/Y H:i', strtotime($user['created_at'])) ?>
                    </li>
                </ul>
            </div>
        
            <div class="col-md-6">
                <h5>Assinatura e Pagamentos</h5>
                <ul class="list-group">
                    <li class="list-group-item">
                        <strong>Status:</strong>
                        <span class="badge bg-<?= $user['active'] ? 'success' : 'danger' ?>">
                            <?= $user['active'] ? 'Ativo' : 'Inativo' ?>
                        </span>
                    </li>
                    <li class="list-group-item">
                        <strong>Plano Atual:</strong>
                        <?= $user[7] ?? 'Nenhum' ?>
                    </li>
                    <li class="list-group-item">
                        <strong>Expira em:</strong>
                        <?= $user['expired_in'] ? date('d/m/Y', strtotime($user['expired_in'])) : '-' ?>
                    </li>
                    <li class="list-group-item">
                        <strong>Último Pagamento:</strong>
                        <?php if ($user['payment_id']): ?>
                            <?= date('d/m/Y H:i', strtotime($user['last_payment'])) ?>
                            <span class="badge bg-<?= $user['payment_status'] === 'CONFIRMED' ? 'success' : 'warning' ?>">
                                <?= $user['payment_status'] ?>
                            </span>
                        <?php else: ?>
                            Nenhum registro
                        <?php endif; ?>
                    </li>
                </ul>
            </div>
        </div>
        
                <div class="mt-3">
            <h5>Histórico de Pagamentos</h5>
            <?php
            // Correção do erro: execução e fetch separados
            $paymentsStmt = $pdo->prepare("
                SELECT * FROM pix 
                WHERE user_id = ? 
                ORDER BY created_at DESC
            ");
            $paymentsStmt->execute([$userId]);
            $payments = $paymentsStmt->fetchAll();
            ?>
            
            <?php if (count($payments) > 0): ?>
                <div class="list-group">
                    <?php foreach ($payments as $payment): ?>
                    <div class="list-group-item">
                        <div class="d-flex justify-content-between">
                            <div>
                                <?= date('d/m/Y H:i', strtotime($payment['created_at'])) ?>
                                <span class="badge bg-<?= $payment['status'] === 'CONFIRMED' ? 'success' : 'warning' ?>">
                                    <?= $payment['status'] ?>
                                </span>
                            </div>
                            <div>
                                ID: <?= $payment['payment_id'] ?>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            <?php else: ?>
                <div class="alert alert-danger">Nenhum pagamento registrado</div>
            <?php endif; ?>
        </div>
            </div>
        </div>
    </div>
</body>
</html>