<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Gerenciar Usuários</title>
    <!-- Link para o favicon -->
    <link rel="icon" href="https://www.pokemongobrasil.com/wp-content/uploads/2015/09/cropped-favicon.png" type="image/x-icon">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/1.13.1/css/jquery.dataTables.min.css" rel="stylesheet">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>

    <style>
        .sidebar {
            height: 100vh;
            position: fixed;
            width: 280px;
            background-color: #f8f9fa;
            padding: 20px;
        }
        .main-content {
            margin-left: 280px;
            padding: 20px;
        }
    </style>
</head>
<body>

    <?php include_once("menu-lateral.php"); ?>

    <div class="main-content">
        <h2 class="mb-4">Gerenciamento de Usuários</h2>

        <div class="table">
            <table id="usersTable" class="table table-striped">
                <thead class="bg-dark text-white">
                    <tr>
                        <th>ID</th>
                        <th>Nome</th>
                        <th>Email</th>
                        <th>Perfil</th>
                        <th>Assinatura</th>
                        <th>Status</th>
                        <th>Cadastro</th>
                        <th>Ações</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </div>

    <script>
    $(document).ready(function() {
    $('#usersTable').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": "usuarios_ajax.php",
        "columns": [
            { "data": "id" },
            { "data": "name" },
            { "data": "email" },
            { 
                "data": "role",
                "render": function(data) {
                    return `<span class="badge bg-${data === 'admin' ? 'danger' : 'primary'}">${data.charAt(0).toUpperCase() + data.slice(1)}</span>`;
                }
            },
            { 
                "data": "premuim",
                "render": function(data, type, row) {
                    if (data) {
                        return `<span class="badge bg-success">Em Andamento</span><br>
                                <small>Plano: ${row.pack_name || 'Sem Plano'}</small><br>
                                <small>Expira: ${row.expired_in ? new Date(row.expired_in).toLocaleDateString() : 'Sem data'}</small>`;
                    } else {
                        return `<span class="badge bg-secondary">Inválida/Vencida</span>`;
                    }
                }
            },
            { 
                "data": "active",
                "render": function(data) {
                    return `<span class="badge bg-${data ? 'success' : 'danger'}">${data ? 'Ativo' : 'Inativo'}</span>`;
                }
            },
            { 
                "data": "created_at",
                "render": function(data) {
                    return new Date(data).toLocaleDateString();
                }
            },
            { 
                "data": "id",
                "render": function(data) {
                    return `<a href="user_details.php?id=${data}" class="btn btn-secondary btn-small text-uppercase">Detalhes</a>`;
                }
            }
        ],
        "pageLength": 10, // Quantidade de registros por página
        "paging": true,  // Garante que a paginação esteja ativada
        "pagingType": "full_numbers", // Estilo de paginação completo (<< < 1 2 3 > >>)
        "lengthMenu": [5, 10, 25, 50, 100, 500], // Opções para alterar o número de registros por página
        "language": {
            "lengthMenu": "Mostrar _MENU_ registros por página",
            "zeroRecords": "Nenhum registro encontrado",
            "info": "Mostrando página _PAGE_ de _PAGES_",
            "infoEmpty": "Nenhum registro disponível",
            "infoFiltered": "(filtrado de _MAX_ registros no total)",
            "search": "Pesquisar:",
            "paginate": {
                "first": "Primeira",
                "last": "Última",
                "next": "Próxima",
                "previous": "Anterior"
            }
        }
    });
});

    </script>
</body>
</html>
