<?php
session_start();
require_once '../config.php';

// Verificar autenticação e permissão
if (!isset($_SESSION['admpag_user'])) {
    echo json_encode(["error" => "Não autorizado"]);
    exit;
}

// Definições do DataTables
$start = isset($_GET['start']) ? (int) $_GET['start'] : 0;
$length = isset($_GET['length']) ? (int) $_GET['length'] : 50; // Padrão 50 por página
$searchValue = isset($_GET['search']['value']) ? trim($_GET['search']['value']) : '';

// Construção da query principal
$query = "SELECT * FROM users";
$conditions = [];

// Filtragem por pesquisa (se existir)
if (!empty($searchValue)) {
    $conditions[] = "(name LIKE :search OR email LIKE :search OR role LIKE :search)";
}

if (count($conditions) > 0) {
    $query .= " WHERE " . implode(" AND ", $conditions);
}

$query .= " ORDER BY created_at DESC LIMIT :start, :length";

// Preparação da query
$stmt = $pdo->prepare($query);

// Bind de valores dinâmicos
if (!empty($searchValue)) {
    $stmt->bindValue(':search', '%' . $searchValue . '%', PDO::PARAM_STR);
}
$stmt->bindValue(':start', $start, PDO::PARAM_INT);
$stmt->bindValue(':length', $length, PDO::PARAM_INT);
$stmt->execute();

// Pegar total de registros (sem paginação)
$totalQuery = "SELECT COUNT(*) as total FROM users";
$totalStmt = $pdo->query($totalQuery);
$totalRecords = $totalStmt->fetch()['total'];

// Enviar resposta JSON para o DataTables
$usuarios = $stmt->fetchAll(PDO::FETCH_ASSOC);
$response = [
    "draw" => isset($_GET['draw']) ? (int) $_GET['draw'] : 1,
    "recordsTotal" => $totalRecords,
    "recordsFiltered" => count($usuarios),
    "data" => $usuarios
];

echo json_encode($response);
?>
