<?php
require_once __DIR__ . '/../vendor/autoload.php';

use MercadoPago\MercadoPago;
use MercadoPago\Payment;
use MercadoPago\Customer;

// Configura o token de acesso
MercadoPago::setAccessToken('MERCADO_PAGO_ACCESS_TOKEN');

class MercadoPagoClient {
    private $client;

    public function __construct($accessToken) {
        MercadoPago::setAccessToken($accessToken); // Configura o token de acesso
    }

    public function criarPagamentoPix($valor, $email, $cpfCnpj, $descricao) {
        try {
            // Criação do pagamento via PIX
            $payment = new Payment();
            $payment->transaction_amount = $valor;
            $payment->payment_method_id = "pix";  // Método de pagamento PIX
            $payment->payer = array(
                "email" => $email,
                "first_name" => "Cliente",
                "last_name" => "Teste",
                "identification" => array(
                    "type" => strlen($cpfCnpj) == 11 ? "CPF" : "CNPJ",
                    "number" => $cpfCnpj
                )
            );
            $payment->description = $descricao;

            // Criação do pagamento
            $payment->save();

            // Verifica se o pagamento foi realizado com sucesso
            if ($payment->status === 'approved') {
                return $payment;
            } else {
                throw new Exception("Pagamento não aprovado, status: " . $payment->status);
            }

        } catch (Exception $e) {
            throw new Exception("Erro ao criar pagamento via Mercado Pago: " . $e->getMessage());
        }
    }
}
?>