<?php
session_start();
require_once 'config.php';
require_once 'AsaasClient.php';

// Verificar se há mensagens de erro na sessão
if (isset($_SESSION['error'])) {
    $error = $_SESSION['error'];
    unset($_SESSION['error']);
}

// Buscar planos disponíveis na tabela "planospix"
try {
    $stmt = $pdo->query("SELECT * FROM planospix ORDER BY price ASC");
    $plans = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    $error = "Erro ao buscar planos: " . $e->getMessage();
    $plans = [];
}

// Variável para verificar se o email já existe
$emailExistente = null;
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Recebe e sanitiza os dados
    $email    = isset($_POST['email']) ? filter_var($_POST['email'], FILTER_SANITIZE_EMAIL) : null;
    $cpfcnpj  = isset($_POST['cpfcnpj']) ? filter_var($_POST['cpfcnpj'], FILTER_SANITIZE_SPECIAL_CHARS) : null;
    $telefone = isset($_POST['tel']) ? filter_var($_POST['tel'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

    // Verificação simples dos campos
    if (empty($cpfcnpj) || empty($telefone)) {
        $error = "CPF/CNPJ ou telefone não podem ser vazios.";
    } elseif (!preg_match('/^\d{11}$/', $telefone)) {
        $error = "Número de telefone inválido.";
    } elseif (!preg_match('/^\d{11,14}$/', $cpfcnpj)) {
        $error = "CPF/CNPJ inválido.";
    } elseif ($email) {
        // Verifica se o e-mail existe na tabela users
        $stmt = $pdo->prepare("SELECT * FROM users WHERE email = :email");
        $stmt->bindParam(':email', $email);
        $stmt->execute();
        $emailExistente = $stmt->fetch(PDO::FETCH_ASSOC);
    }
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Assinatura</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .plan-card {
            transition: transform 0.3s;
            border: 1px solid #2b2d42;
        }
        .plan-card:hover {
            transform: translateY(-10px);
            border-color: #ef233c;
        }
        .pix-instructions {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 20px;
        }
    </style>
</head>
<body class="bg-dark text-light">
    <div class="container py-5">
        <h1 class="text-center mb-5">Escolha Seu Plano</h1>

        <!-- Exibe mensagem de erro, se houver -->
        <?php if (isset($error)): ?>
            <div class="alert alert-danger text-center"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>

        <!-- Formulário para verificação do e-mail -->
        <div class="row justify-content-center mb-5">
            <div class="col-md-12 col-sm-12 col-lg-7">
                <form method="post" action="pagamento.php" class="card bg-secondary text-white p-4">
                    <div class="row">
                        <div class="mb-3 col-md-6">
                            <label for="cpfcnpj" class="form-label">Digite CPF ou CNPJ cadastrado</label>
                            <input type="text" placeholder="Digite CPF/CNPJ" id="cpfcnpj" name="cpfcnpj" class="form-control" required>
                        </div>
                        <div class="mb-3 col-md-6">
                            <label for="tel" class="form-label">Digite seu WhatsApp cadastrado</label>
                            <input type="tel" placeholder="WhatApp" id="telefone" name="tel" class="form-control" required>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="email" class="form-label">Digite seu e-mail cadastrado</label>
                        <input type="email" placeholder="Digite seu email" id="email" name="email" class="form-control" required>
                        <div id="emailHelp" class="form-text text-light">Verificaremos se você já possui cadastro</div>
                    </div>
                    <button type="submit" class="btn btn-primary w-100">Verificar</button>
                </form>
            </div>
        </div>

        <!-- Se o e-mail foi verificado, exibe os planos -->
        <div id="emailResult" class="mt-3">
            <?php if ($emailExistente): ?>
                <div class="alert alert-success">E-mail verificado com sucesso!</div>
                <div id="planosContainer" class="mt-3">
                    <h2 class="text-center mb-4">Escolha Seu Plano</h2>
                    <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 row-cols-xl-4 g-4">
                        <?php foreach ($plans as $plan): ?>
                            <div class="col">
                                <form method="post" action="processa_pagamento.php" class="plan-form" id="assinaturaForm">
    <input type="hidden" name="mobilePhone" value="<?= htmlspecialchars($telefone ?? '') ?>"> 
    <input type="hidden" name="cpfCnpj" value="<?= htmlspecialchars($cpfcnpj ?? '') ?>"> 
    <input type="hidden" name="email" value="<?= htmlspecialchars($email) ?>"> 
    <input type="hidden" name="plan_id" value="<?= $plan['id'] ?>"> 
    <div class="card h-100 bg-secondary text-white plan-card">
        <div class="card-body text-center">
            <h3><?= htmlspecialchars($plan['name']) ?></h3>
            <div class="display-4 mb-3">R$ <?= number_format($plan['price'], 2, ',', '.') ?></div>
            <button type="submit" name="Assinar" class="btn btn-danger btn-lg w-100">Assinar</button>
        </div>
    </div>
</form>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php elseif ($_SERVER['REQUEST_METHOD'] === 'POST' && !$emailExistente): ?>
                <div class="alert alert-danger">E-mail não cadastrado. <a href="/cadastro" class="alert-link">Criar conta</a></div>
            <?php endif; ?>
        </div>
    </div>
<script>
document.getElementById('assinaturaForm').addEventListener('submit', function (e) {
    e.preventDefault(); // Impede o envio tradicional do formulário

    // Captura os dados do formulário
    const formData = new FormData(this);

    // Envia os dados via Fetch API
    fetch('processa_pagamento.php', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json()) // Converte a resposta para JSON
    .then(data => {
        if (data.success) {
            // Redireciona para a página de QR Code
            window.location.href = data.redirect_url;
        } else {
            // Exibe mensagem de erro
            alert(data.error_message);
        }
    })
    .catch(error => {
        console.error('Erro:', error);
        alert('Ocorreu um erro ao processar a requisição.');
    });
});
</script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
