<?php
require_once 'config.php';
require_once 'AsaasClient.php';

// Verifica se o par09metro payment_id foi passado via GET
if (!isset($_GET['payment_id'])) {
    header('Location: pagamento.php');
    exit;
}

$paymentId = $_GET['payment_id'];

// Buscar os dados do pagamento na tabela "pix"
$stmt = $pdo->prepare("SELECT * FROM pix WHERE payment_id = ?");
$stmt->execute([$paymentId]);
$pix = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$pix) {
    die("Pagamento n00o encontrado.");
}

// Obter o plan_id via GET (pois ele n00o est armazenado na tabela "pix")
if (isset($_GET['plan_id'])) {
    $planId = $_GET['plan_id'];
} else {
    die("Plano n00o especificado.");
}

// Buscar os dados do plano na tabela "planospix"
$stmtPlan = $pdo->prepare("SELECT * FROM planospix WHERE id = ?");
$stmtPlan->execute([$planId]);
$plan = $stmtPlan->fetch(PDO::FETCH_ASSOC);

if (!$plan) {
    die("Plano n00o encontrado.");
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Pagamento PIX</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #343a40;
            color: #f8f9fa;
        }
        .container {
            margin-top: 50px;
        }
    </style>
</head>
<body>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-6 text-center">
            <h1 class="mb-4">Finalize o Pagamento</h1>
            <!-- Exibe o QR Code -->
            <img src="<?= htmlspecialchars($pix['qr_code']) ?>" class="img-fluid mb-3" alt="QR Code de Pagamento">
            <!-- Exibe o valor do plano e a chave PIX -->
            <div class="card bg-secondary text-white mb-4">
                <div class="card-body">
                    <p class="lead">Valor: R$ <?= number_format($plan['price'], 2, ',', '.') ?></p>
                    <div class="input-group mb-3">
                        <input type="text" id="pixCode" value="<?= htmlspecialchars($pix['payload']) ?>" class="form-control" readonly>
                        <button onclick="copyPix()" class="btn btn-outline-light">Copiar</button>
                    </div>
                </div>
            </div>
            <!-- Cron00metro de 30 minutos -->
            <div class="alert alert-warning">
                Tempo restante: <span id="countdown">05:00</span>
            </div>
        </div>
    </div>
</div>

<script>
let timeLeft = 300; // 1800 segundos = 30 minutos

function updateTimer() {
    const minutes = Math.floor(timeLeft / 60);
    const seconds = timeLeft % 60;
    document.getElementById('countdown').textContent =
        `${String(minutes).padStart(2, '0')}:${String(seconds).padStart(2, '0')}`;
    
    if (timeLeft <= 0) {
        window.location.reload();
    } else {
        timeLeft--;
        setTimeout(updateTimer, 1000);
    }
}

function copyPix() {
    const pixCode = document.getElementById('pixCode');
    navigator.clipboard.writeText(pixCode.value)
        .then(() => {
            alert('Cdigo copiado!');
        })
        .catch(() => {
            alert('Erro ao copiar o cdigo.');
        });
}

updateTimer();
</script>
</body>
</html>
