<?php
// Supondo que você já tenha os dados do plano e usuário carregados
$telefone = $telefone ?? '';
$cpfcnpj = $cpfcnpj ?? '';
$email = $email ?? '';
$plan = [
    'id' => 1,  // Exemplo de ID
    'name' => 'Plano Básico',  // Exemplo de nome do plano
    'price' => 99.90  // Exemplo de preço
];
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Assinatura - <?= htmlspecialchars($plan['name']) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script>
        function validarFormulario() {
            const telefone = document.getElementById("telefone").value;
            const cpfcnpj = document.getElementById("cpfcnpj").value;
            const email = document.getElementById("email").value;

            if (!telefone || !cpfcnpj || !email) {
                alert("Por favor, preencha todos os campos antes de prosseguir.");
                return false;
            }
            return true;
        }
    </script>
</head>
<body class="bg-dark text-light">
    <div class="container py-5">
        <h1 class="text-center mb-5">Assine o Plano</h1>

        <!-- Exibe mensagem de erro, se houver -->
        <?php if (isset($_SESSION['error'])): ?>
            <div class="alert alert-danger text-center"><?= htmlspecialchars($_SESSION['error']) ?></div>
            <?php unset($_SESSION['error']); ?>
        <?php endif; ?>

        <!-- Formulário para selecionar plano -->
        <form method="post" action="/processamento/processa_pagamento_mercado_pago.php" class="plan-form" onsubmit="return validarFormulario()">
            <input type="hidden" name="mobilePhone" value="<?= htmlspecialchars($telefone) ?>"> 
            <input type="hidden" name="cpfCnpj" value="<?= htmlspecialchars($cpfcnpj) ?>"> 
            <input type="hidden" name="email" value="<?= htmlspecialchars($email) ?>"> 
            <input type="hidden" name="plan_id" value="<?= $plan['id'] ?>"> 

            <div class="card h-100 bg-secondary text-white plan-card">
                <div class="card-body text-center">
                    <h3><?= htmlspecialchars($plan['name']) ?></h3>
                    <div class="display-4 mb-3">
                        R$ <?= number_format($plan['price'], 2, ',', '.') ?>
                    </div>
                    <button type="submit" name="Assinar" class="btn btn-danger btn-lg w-100">Assinar</button>
                </div>
            </div>
        </form>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
