<?php
session_start(); // Garante que a sessão está iniciada

// Verifica se existe uma mensagem de erro armazenada na sessão
if (isset($_SESSION['error'])) {
    $error_message = $_SESSION['error'];
    unset($_SESSION['error']);  // Limpa a mensagem de erro após exibir
} else {
    $error_message = 'Ocorreu um erro desconhecido.';
}

?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Erro no Pagamento</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #1c1c1c;
            color: #fff;
        }
        .error-box {
            max-width: 500px;
            margin: auto;
            padding: 30px;
            background: #222;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(255, 0, 0, 0.5);
        }
        .countdown {
            font-size: 20px;
            font-weight: bold;
        }
    </style>
    <script>
    let timeLeft = 15;

    // Função para atualizar o contador na tela
    function updateCountdown() {
        let countdownElement = document.getElementById("countdown");
        let countdownText = `Você será redirecionado automaticamente em `;

        // Adiciona o número com a cor dinâmica
        let coloredNumber = `<span style="color:${getColor(timeLeft)}">${timeLeft}</span>`;

        // Atualiza o conteúdo da página com o número colorido
        countdownElement.innerHTML = countdownText + coloredNumber + ` segundos.`;

        // Quando o contador chegar a zero, exibe uma bomba e redireciona
        if (timeLeft === 0) {
            countdownElement.innerHTML = '<span style="font-size: 30px; color: red;">💣 BOOM! Redirecionando...</span>';
            setTimeout(() => {
                window.location.href = "/public/index.php"; // Redireciona após exibir a bomba
            }, 1000); // Espera 1 segundo para mostrar a bomba antes de redirecionar
        } else {
            timeLeft--; // Diminui o tempo a cada segundo
            setTimeout(updateCountdown, 1000); // Atualiza a cada 1 segundo
        }
    }

    // Função para definir a cor com base no tempo restante
    function getColor(time) {
        if (time <= 0) {
            return "red"; // Quando for zero, já fica vermelha
        }
        if (time <= 1) {
            return "darkred"; // Quando chegar em 1 segundo, vermelho escuro
        }
        if (time <= 2) {
            return "red"; // Quando chegar em 2 segundos, vermelho
        }
        if (time <= 3) {
            return "#ff4500"; // Cor entre laranja e vermelho
        }
        if (time <= 4) {
            return "orange"; // Quando chegar em 4 segundos, laranja
        }
        if (time <= 5) {
            return "yellow"; // Quando chegar em 5 segundos, amarelo
        }
        return "white"; // Cor padrão para números maiores que 5
    }

    // Inicia o contador assim que a página carrega
    window.onload = updateCountdown;
</script>

<body class="d-flex justify-content-center align-items-center vh-100">
    <div class="error-box text-center">
        <h1 class="mb-4 text-danger">Erro no Pagamento</h1>
        <p><?= htmlspecialchars($error_message, ENT_QUOTES, 'UTF-8') ?></p>
        <div class="row">
            <div class="col-md-6">
                <a href="/public/index.php" class="btn btn-success w-100 mt-3">Tentar Novamente</a>
            </div>
            <div class="col-md-6">
                <a href="javascript:history.back()" class="btn btn-light w-100 mt-3">Voltar</a>
            </div>
        </div>
        <p class="mt-3 text-white countdown" id="countdown">Você será redirecionado automaticamente em 15 segundos.</p>
    </div>
</body>

</html>
