<?php
// public/pagamento_pix.php

session_start();

// Verifica se o payment_id e os QR Codes estão presentes na sessão
if (!isset($_SESSION['payment_id']) || !isset($_SESSION['qr_code']) || !isset($_SESSION['qr_code_base64'])) {
    // Redireciona para a página inicial com uma mensagem de erro
    $_SESSION['error_message'] = "Erro ao gerar o pagamento Pix. Tente novamente.";
    header("Location: index.php");
    exit();
}

// Obtém os dados do QR Code da sessão
$qr_code = $_SESSION['qr_code'];
$qr_code_base64 = $_SESSION['qr_code_base64'];
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Pagamento Pix</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            text-align: center;
            padding: 20px;
            background-color: #f4f4f4;
        }
        h1 {
            color: #28a745;
        }
        img {
            margin-top: 20px;
            border: 2px solid #ddd;
            padding: 10px;
            background-color: white;
            border-radius: 10px;
        }
        p {
            font-size: 18px;
            color: #333;
        }
        .btn {
            padding: 10px 20px;
            text-decoration: none;
            color: white;
            background-color: #007bff;
            border-radius: 5px;
            margin-top: 20px;
        }
        .btn-danger {
            background-color: #dc3545;
        }
        .alert {
            padding: 10px;
            margin-bottom: 20px;
            color: white;
            background-color: #dc3545;
            border-radius: 5px;
        }
    </style>
</head>
<body>
    <h1>Pague com Pix</h1>

    <!-- Exibe a mensagem de erro, se houver -->
    <?php if (isset($_SESSION['error_message'])): ?>
        <div class="alert"><?= $_SESSION['error_message']; ?></div>
        <?php unset($_SESSION['error_message']); // Apaga a mensagem após exibição ?>
    <?php endif; ?>

    <!-- Verifica se o QR Code está disponível -->
    <?php if (!empty($qr_code_base64)): ?>
        <img src="<?= htmlspecialchars($qr_code_base64) ?>" alt="QR Code Pix">
        <p>Código Pix: <?= htmlspecialchars($qr_code) ?></p>
    <?php else: ?>
        <p>Erro ao gerar o QR Code. Tente novamente mais tarde.</p>
    <?php endif; ?>

    <!-- Botão para voltar à página inicial -->
    <a href="index.php" class="btn btn-primary">Voltar para a página inicial</a>

    <!-- Botão para tentar novamente (caso haja erro na geração do pagamento) -->
    <?php if (empty($qr_code_base64)): ?>
        <a href="gerar_pagamento.php" class="btn btn-danger">Tentar Novamente</a>
    <?php endif; ?>

    <!-- Redirecionamento automático após 10 segundos -->
    <script>
        setTimeout(function() {
            window.location.href = "index.php";  // Redireciona após 10 segundos
        }, 10000);  // 10000 milissegundos = 10 segundos
    </script>
</body>
</html>
