<?php
// public/processa_pagamento.php

session_start();
require_once __DIR__ . '/../src/MercadoPagoClient.php';
require_once __DIR__ . '/../config.php';  // Inclua o arquivo de configuração se necessário (configurações do MercadoPago)

// Verificar se o usuário está logado (se aplicável)
if (!isset($_SESSION['user_id'])) {
    $_SESSION['error'] = "Você precisa estar logado para realizar a compra.";
    header("Location: login.php");
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Sanitizar dados do formulário
    $plan_id = isset($_POST['plan_id']) ? filter_var($_POST['plan_id'], FILTER_SANITIZE_NUMBER_INT) : null;
    $price = isset($_POST['price']) ? filter_var($_POST['price'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION) : null;
    $email = isset($_POST['email']) ? filter_var($_POST['email'], FILTER_SANITIZE_EMAIL) : null;

    // Verificar se os campos obrigatórios foram preenchidos corretamente
    if (empty($plan_id) || empty($price) || empty($email)) {
        $_SESSION['error'] = "Dados incompletos. Verifique o plano, preço e e-mail.";
        header("Location: index.php");
        exit();
    }

    try {
        // Cria o pagamento Pix no MercadoPago
        $mpClient = new MercadoPagoClient();

        // Criar o pagamento Pix com o preço, e-mail e outras informações necessárias
        $pagamento = $mpClient->criarPagamentoPix($price, $email);

        if ($pagamento && isset($pagamento['id'])) {
            // Salvar o ID do pagamento e QR Code na sessão
            $_SESSION['payment_id'] = $pagamento['id'];
            $_SESSION['qr_code'] = $pagamento['qr_code'];
            $_SESSION['qr_code_base64'] = $pagamento['qr_code_base64'];

            // Redirecionar para a página de pagamento Pix
            header("Location: pagamento_pix.php");
            exit();
        } else {
            $_SESSION['error'] = "Erro ao criar o pagamento. Tente novamente mais tarde.";
            header("Location: index.php");
            exit();
        }
    } catch (Exception $e) {
        // Captura erros e exibe mensagem amigável
        $_SESSION['error'] = "Ocorreu um erro ao processar o pagamento: " . $e->getMessage();
        header("Location: index.php");
        exit();
    }
} else {
    // Caso o método de requisição seja inválido
    $_SESSION['error'] = "Método de requisição inválido.";
    unset($_SESSION['user_id']);
    header("Location: index.php");
    exit();
}
