<?php
require_once __DIR__ . '/../../config.php'; // Inclui o arquivo de configuração

// Verifica se a requisição é POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Lê o corpo da requisição
    $payload = file_get_contents('php://input');
    $data = json_decode($payload, true);

    // Verifica se o payload contém o ID do pagamento
    if (isset($data['data']['id'])) {
        $payment_id = $data['data']['id'];

        // Busca os detalhes do pagamento na API do Mercado Pago
        $access_token = MERCADO_PAGO_ACCESS_TOKEN; // Token de acesso
        $url = "https://api.mercadopago.com/v1/payments/$payment_id?access_token=$access_token";

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        curl_close($ch);

        $payment = json_decode($response, true);

        // Atualiza o status do pagamento no banco de dados
        if (isset($payment['status'])) {
            $status = $payment['status'];

            try {
                $stmt = $pdo->prepare("UPDATE pagamentos SET status = :status WHERE payment_id = :payment_id");
                $stmt->execute([
                    ':status' => $status,
                    ':payment_id' => $payment_id
                ]);

                // Log de sucesso
                error_log("Pagamento $payment_id atualizado para status: $status");
            } catch (PDOException $e) {
                // Log de erro
                error_log("Erro ao atualizar pagamento $payment_id: " . $e->getMessage());
            }
        }
    }
}

// Responde ao Mercado Pago com status 200 (OK)
http_response_code(200);
?>