<?php
session_start();

// Verifica se o payment_id está na URL e sanitiza a entrada
$payment_id = isset($_GET['payment_id']) ? htmlspecialchars(trim($_GET['payment_id'])) : null;

// Verifica se o ID do pagamento está presente
if (!$payment_id) {
    $_SESSION['error'] = "ID do pagamento não encontrado.";
    header("Location: /public/falha.php");
    exit();
}

// Opcional: Armazena o payment_id na sessão para uso futuro
$_SESSION['payment_id'] = $payment_id;
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Pagamento Realizado</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-dark text-light">
    <div class="container py-5 text-center">
        <h1 class="mb-4 text-success">Pagamento Realizado com Sucesso!</h1>
        <p><strong>ID do Pagamento:</strong> <span class="text-info"><?= $payment_id ?></span></p>
        <p>Verifique seu e-mail para obter o QR Code do PIX.</p>

        <?php if (isset($_SESSION['qr_code_url'])): ?>
            <p><strong>Escaneie o QR Code abaixo:</strong></p>
            <img src="<?= htmlspecialchars($_SESSION['qr_code_url']) ?>" alt="QR Code PIX" class="img-fluid border rounded p-2 bg-light">
            <?php unset($_SESSION['qr_code_url']); ?>
        <?php else: ?>
            <p class="text-warning">O QR Code do PIX ainda não está disponível. Por favor, verifique seu e-mail.</p>
        <?php endif; ?>

        <a href="/public/index.php" class="btn btn-primary mt-3">Voltar</a>
    </div>
</body>
</html>
