<?php
// src/MercadoPagoClient.php

require_once __DIR__ . '/../config.php'; 
require_once __DIR__ . '/../vendor/autoload.php';

use MercadoPago\Client\Payment\PaymentClient;
use MercadoPago\MercadoPagoConfig;

class MercadoPagoClient
{
    private $client;

    public function __construct()
    {
        MercadoPagoConfig::setAccessToken(MERCADO_PAGO_ACCESS_TOKEN);
        $this->client = new PaymentClient();
    }

    /**
     * Cria um pagamento Pix.
     *
     * @param float $valor Valor da transação.
     * @param string $email E-mail do pagador.
     * @return array Retorna os dados do pagamento.
     */
    public function criarPagamentoPix($valor, $email)
    {
        $payment = $this->client->create([
            "transaction_amount" => (float)$valor,
            "payment_method_id" => "pix",
            "payer" => [
                "email" => $email,
                "first_name" => "Cliente", // Pode ser dinâmico
                "last_name" => "Teste",    // Pode ser dinâmico
            ]
        ]);

        return [
            'id' => $payment->id,
            'qr_code' => $payment->point_of_interaction->transaction_data->qr_code,
            'qr_code_base64' => $payment->point_of_interaction->transaction_data->qr_code_base64,
        ];
    }
}