<?php
// Cabeçalho HTTP para retornar JSON
header('Content-Type: application/json; charset=UTF-8');

// Verifica parâmetros de paginação
$start = isset($_GET['start']) ? (int) $_GET['start'] : 0;
$length = isset($_GET['length']) ? (int) $_GET['length'] : 50;
$searchValue = isset($_GET['search']['value']) ? trim($_GET['search']['value']) : '';

// Obtendo o total de registros SEM FILTRO
$totalQuery = "SELECT COUNT(*) as total FROM users";
$totalStmt = $pdo->prepare($totalQuery);
$totalStmt->execute();
$totalRecords = $totalStmt->fetchColumn();

// Montando a consulta com filtros
$query = "SELECT * FROM users AS u INNER JOIN planospix AS p ORDER BY u.id DESC";
$conditions = [];

if (!empty($searchValue)) {
    $conditions[] = "(name LIKE :search OR email LIKE :search OR role LIKE :search)";
}

if (count($conditions) > 0) {
    $query .= " WHERE " . implode(" AND ", $conditions);
}

// Obtendo o total de registros FILTRADOS corretamente
$filteredQuery = "SELECT COUNT(*) as total FROM users";
if (!empty($searchValue)) {
    $filteredQuery .= " WHERE " . implode(" AND ", $conditions);
}
$filteredStmt = $pdo->prepare($filteredQuery);
if (!empty($searchValue)) {
    $filteredStmt->bindValue(':search', '%' . $searchValue . '%', PDO::PARAM_STR);
}
$filteredStmt->execute();
$totalFiltered = $filteredStmt->fetchColumn(); // Deve retornar o número correto

// Adicionando segmentação (LIMIT para paginação)
$query .= " ORDER BY created_at DESC LIMIT :start, :length";
$stmt = $pdo->prepare($query);
if (!empty($searchValue)) {
    $stmt->bindValue(':search', '%' . $searchValue . '%', PDO::PARAM_STR);
}
$stmt->bindValue(':start', $start, PDO::PARAM_INT);
$stmt->bindValue(':length', $length, PDO::PARAM_INT);
$stmt->execute();

$usuarios = $stmt->fetchAll(PDO::FETCH_ASSOC);

/*echo "<pre>";
print_r($usuarios);
echo "</pre>";

die();*/

// Retornando JSON para o DataTables
$response = [
    "draw" => isset($_GET['draw']) ? (int) $_GET['draw'] : 1,
    "recordsTotal" => $totalRecords,  
    "recordsFiltered" => $totalFiltered,  
    "data" => $usuarios
];

// Enviar a resposta JSON
echo json_encode($response);
?>
