<?php
require_once 'config.php';
require_once 'AsaasClient.php';

$payload = json_decode(file_get_contents('php://input'), true);
$asaasConfig = $pdo->query("SELECT * FROM asaas_settings LIMIT 1")->fetch();

// Verificar assinatura
if (!isset($_SERVER['HTTP_ASAAS_SIGNATURE']) || $_SERVER['HTTP_ASAAS_SIGNATURE'] !== $asaasConfig['webhook_token']) {
    http_response_code(403);
    exit;
}

// Atualizar status do pagamento
$stmt = $pdo->prepare("UPDATE pix SET status = ? WHERE payment_id = ?");
$stmt->execute([$payload['status'], $payload['id']]);

// Se confirmado, atualizar usuário
if ($payload['status'] === 'CONFIRMED') {
    // Certifique-se de que a variável $plan está definida corretamente
    // Você precisa pegar o plano relacionado a este pagamento, por exemplo:
    $pix = $pdo->prepare("SELECT * FROM pix WHERE payment_id = ?");
    $pix->execute([$payload['id']]);
    $pix = $pix->fetch();

    // Supondo que o plano esteja armazenado de alguma forma no banco de dados
    $plan = $pdo->prepare("SELECT * FROM plans WHERE id = ?");
    $plan->execute([$pix['plan_id']]);  // Aqui assumimos que cada pagamento tem um 'plan_id'
    $plan = $plan->fetch();

    if ($plan) {
        $expiration = date('Y-m-d H:i:s', strtotime("+{$plan['duration_days']} days"));
        
        $stmt = $pdo->prepare("UPDATE users SET 
            premuim = 1,
            pack_id = ?,
            expired_in = ?
            WHERE id = ?");
            
        $stmt->execute([
            $plan['id'],
            $expiration,
            $pix['user_id']
        ]);
    } else {
        // Se o plano não for encontrado, você pode registrar um erro ou retornar uma resposta adequada.
        http_response_code(400); // Plano não encontrado
        exit;
    }
}

http_response_code(200);
?>
